function [ Rx, qx ] = QuatRotAXXB( Ra,Rb )
%Solves the system Ra*Rx=Rx*Rb for Rx
% 
% Copyright (C) Russell H. Taylor 2013
% For use with CIS I only
% Do not redistribute without written permission from Russell Taylor

N = size(Ra,1);
M = [];
for i=1:N
    qa = quaternion(Ra(i));
    qb = quaternion(Rb(i));
    vapvb = [qa.x+qb.x,qa.y+qb.y,qa.z+qb.z];
    vamvb = [qa.x-qb.x,qa.y-qb.y,qa.z-qb.z];
    raprb = qa.r+qb.r;
    ramrb = qa.r-qb.r;
    M44 = [[ ramrb,    -vapvb(3),  vapvb(2),vamvb(1)];
           [ vapvb(3),  ramrb,    -vapvb(1),vamvb(2)];
           [-vapvb(2),  vapvb(1),  ramrb,   vamvb(3)];
           [-vamvb,                         ramrb]];
    M = [M;M44];        
end
[U,S,V]=svd(M,'econ');
qx = quaternion(V(:,4));
Rx = RotMx(qx);
end

